<?php
date_default_timezone_set('America/Bahia');

$certificado = __DIR__ . '/certificado.pem';
$chave = __DIR__ . '/chave.pem';

$senha = '130203';
$url = 'https://ehr-auth.saude.gov.br/api/token';

$ch = curl_init();

curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSLCERT, $certificado);
curl_setopt($ch, CURLOPT_SSLKEY, $chave);
curl_setopt($ch, CURLOPT_SSLKEYPASSWD, $senha);

$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo 'Erro na requisição: ' . curl_error($ch);
    curl_close($ch);
    exit;
}

curl_close($ch);

$data = json_decode($response, true);

if (!isset($data['access_token'])) {
    echo "Erro ao obter o token.";
    exit;
}

$token = $data['access_token'];
$expiracao = date('Y-m-d H:i:s', strtotime('+30 minutes'));

$tokenData = "TOKEN: $token\nExpiração: $expiracao";

file_put_contents('token.txt', $tokenData);

echo "Token salvo com sucesso no arquivo token.txt";

?>
